
-- vettori sprint

set sql_safe_updates=0;

SET @applicant=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_LOGIN_CREDENTIAL_INFO');

UPDATE `sql_dtprovider` SET `sqlQuery`="select T1.id as ID,
	T4.`firstName` AS FIRST_NAME,
	T4.`lastName` AS LAST_NAME,
    T4.`emailId` AS EMAIL_ID,
	T4.`mobileNumber` AS MOBILE_NO,
	T4.`mobileCountryCode` AS MOBILE_CODE,
    (select
        distinct FORMAT(sum(feestagehe7_.feeAmount), 0) as y1_
    from
        fee_plan this_ 
    left outer join
        currency currency2_ 
            on this_.currencyId=currency2_.id 
    left outer join
        fee_plan_acad_locations feeplanaca1_ 
            on this_.id=feeplanaca1_.feePlanId 
    left outer join
        prog_batch_seat_config programbat3_ 
            on feeplanaca1_.progBatchSeatConfigId=programbat3_.id 
    left outer join
        fee_plan_rules feeplanrul4_ 
            on this_.id=feeplanrul4_.feePlanId 
    left outer join
        fee_plan_rule_stage feeplanrul5_ 
            on feeplanrul4_.id=feeplanrul5_.feePlanRuleId 
    left outer join
        fee_stage_master feeplansta6_ 
            on feeplanrul5_.stageId=feeplansta6_.id 
    left outer join
        fee_stage_head_config feestagehe7_ 
            on feeplanrul5_.id=feestagehe7_.feePlanRuleStageId 
    where
        this_.feePlanStatus='ACTIVE' 
        and feeplanrul4_.feeSpecificLinkType='NOT_APPLICABLE' 
        and programbat3_.id = T5.progBatchSeatConfigId 
        and feeplansta6_.stageName='Application form sale' 
    group by
        feeplanrul5_.id
) as 'FEE',
'APPLICANT' AS USER_TYPE_KEY,
T3.code AS APPLICATION_CODE,
ml.`code` as LANGUAGE_KEY
 from external_users T1
	left join external_user_association T2 on T2.externalUserId=T1.id
    left join application T3 on T3.id=T2.applicationId
    left join applicant_person T4 on T4.id=T3.applicantPersonId
    left join application_program T5 on T5.applicationId=T3.id
 	left join multi_language ml on T4.correspondence_language=ml.id 
    where T1.id in (namedParams)" , `jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "fee",
            "resultKey": "FEE",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 6
        }
    ]
}' WHERE `dataProviderId`=@applicant;

    
set sql_safe_updates=1;